
schedule("system", initDesktop);

var iconWidth = 48;




function initDesktop()
{
	var desktopIcons = getElementsByAttribute("class", "desktopIcon");
	
	for (var i = 0; i < desktopIcons.length; i++)
	{
		attachEventListener(desktopIcons[i], "mousedown", mousedownDesktopIcon, false);
	}
	
	attachEventListener(document, "mousedown", deselectDesktopIcons, false);

	return true;
}




function mousedownDesktopIcon(event)
{
	if (typeof event == "undefined")
	{
		event = window.event;
	}
	
	deselectDesktopIcons();
	
	this.src = this.src.replace(/\.png/, "_selected.png");
	
	document.movingIcon = this;
	
	attachEventListener(document, "mousemove", mousemoveDesktopIcon, false);
	attachEventListener(document, "mouseup", mouseupDesktopIcon, false);

	stopEvent(event);
	
	return true;	
}




function mouseupDesktopIcon(event)
{
	detachEventListener(document, "mousemove", mousemoveDesktopIcon, false);
	
	var moveCopy = document.getElementById("moveCopy");
	
	if (moveCopy != null);
	{
		var trashIcon = document.getElementById("trashIcon");
		var trashIconPosition = getPosition(trashIcon);
		
		if (event.clientX > trashIconPosition[0] && event.clientX < trashIconPosition[0] + trashIcon.offsetWidth && event.clientY > trashIconPosition[1] && event.clientY < trashIconPosition[1] + trashIcon.offsetHeight)
		{
			document.movingIcon.parentNode.removeChild(document.movingIcon);
			
			trashIcon.src = trashIcon.src = "images/application_icon_trash_full.png";
			
			document.getElementById("safariAppAddressBar").focus();
			
			var dock = document.getElementById("dock");
			
			detachEventListener(dock, "mousemove", mousemoveDock, false);
			attachEventListener(dock, "mouseout", reinitDock, false);
		}
		else
		{
			document.movingIcon.style.left = retrieveComputedStyle(moveCopy, "left");
			document.movingIcon.style.top = retrieveComputedStyle(moveCopy, "top");
		}
		
		moveCopy.parentNode.removeChild(moveCopy);
	}
	
	return true;	
}




function reinitDock()
{
	var dock = document.getElementById("dock");
			
	attachEventListener(dock, "mousemove", mousemoveDock, false);
	
	return true;
}




function mousemoveDesktopIcon(event)
{
	if (typeof event == "undefined")
	{
		event = window.event;
	}
	
	document.getElementById("safariAppAddressBar").focus();
			
	var moveCopy = document.getElementById("moveCopy");
	
	if (moveCopy == null)
	{
		moveCopy = document.createElement("img");
		moveCopy.id = "moveCopy";
		moveCopy.style.left = retrieveComputedStyle(document.movingIcon, "left");
		moveCopy.style.top = retrieveComputedStyle(document.movingIcon, "top");
		moveCopy.src = document.movingIcon.src;
		document.getElementsByTagName("body")[0].appendChild(moveCopy);
	}
	
	var currLeft = parseInt(retrieveComputedStyle(moveCopy, "left"));
	var currTop = parseInt(retrieveComputedStyle(moveCopy, "top"));
	
	document.moveCopy.style.left = currLeft + (event.clientX - document.moveCopy.originalX) + "px";
	document.moveCopy.style.top = currTop + (event.clientY - document.moveCopy.originalY) + "px";
	
	document.moveCopy.originalX = event.clientX;
	document.moveCopy.originalY = event.clientY;
	
	var trashIcon = document.getElementById("trashIcon");
	var trashIconPosition = getPosition(trashIcon);
	
	if (event.clientX > trashIconPosition[0] && event.clientX < trashIconPosition[0] + trashIcon.offsetWidth && event.clientY > trashIconPosition[1] && event.clientY < trashIconPosition[1] + trashIcon.offsetHeight)
	{
		trashIcon.src = trashIcon.src.replace(/\.png/, "_hilite.png");
	}
	else
	{
		trashIcon.src = trashIcon.src.replace(/_hilite/, "");
	}
	
	return true;
}





function deselectDesktopIcons()
{
	var desktopIcons = getElementsByAttribute("class", "desktopIcon");
	
	for (var i = 0; i < desktopIcons.length; i++)
	{
		desktopIcons[i].src = desktopIcons[i].src.replace(/_selected/, "");
	}
}




function writeSystemMenu(menuArray)
{
	var system = document.getElementById("system");	
	var systemMenu = system.getElementsByTagName("ul")[0];
	var systemMenuItems = systemMenu.childNodes;

	for (var i = 0; i < systemMenuItems.length; )
	{
		systemMenu.removeChild(systemMenuItems[i]);
	}

	for (var i = 0; i < menuArray.length; i++)
	{
		var menuItem = document.createElement("li");

		if (i == 0)
		{
			menuItem.className = "first";
		}

		menuItem.appendChild(document.createTextNode(menuArray[i]));

		if (menuArray[i] == "Bookmarks")
		{
			attachEventListener(menuItem, "click", clickMenuItem, false);
		}

		systemMenu.appendChild(menuItem);
	}

	return true;
}
